( function( $ ) {
	/**
 	 * @param $scope The Widget wrapper element as a jQuery element
	 * @param $ The jQuery alias
	 */ 
	var WidgetFloatingMenuHandler = function( $scope, $ ) {
		var action = $(".elementor-grid-item-action");
		action.click(function(){
			var rotateElement = $(this).find("a");
			if($(this).hasClass('active'))
			{
				$(".floating-menu-trigger-open").css("display", "block");
				$(".floating-menu-trigger-close").css("display", "none");
				$(".floating-menu-item").css("display", "none");
				$(this).addClass('deactivate').removeClass('active');
				rotateElement.addClass("false").removeClass("true");
			}
			else
			{
				$(".floating-menu-trigger-open").css("display", "none");
				$(".floating-menu-trigger-close").css("display", "block");
				$(".floating-menu-item").css("display", "block");
				$(this).addClass('active').removeClass('deactivate');
				rotateElement.addClass("true").removeClass("false");
			}
		});

		$(document).scroll(scrollFunction);

		function scrollFunction() {

			const footer = $("footer").outerHeight() + 20;

			if (($(window).innerHeight() + $(window).scrollTop()) >= ($(document.body).outerHeight() - footer)) {
				$(".flm").fadeOut();
			} else {
				$(".flm").fadeIn();
			}
		}

		const titleBackgroundColor = $(".floating-menu-title.actions").css("background-color");

		$('head').append('' +
			'<style>' +
			'.flm .elementor-grid .elementor-grid-item-action.elementor-grid-item:before {' +
			'	border-color: transparent transparent transparent ' + titleBackgroundColor +' !important;' +
			'}' +
			'</style>');
	};

	// Make sure you run this code under Elementor.
	$( window ).on( 'elementor/frontend/init', function() {
		elementorFrontend.hooks.addAction( 'frontend/element_ready/floating-menu.default', WidgetFloatingMenuHandler );
	} );
} )( jQuery );
