# Elementor Floating Menu

Plugin Structure: 
```
assets/
      /js   
      /css  Holds plugin CSS Files
      
widgets/
      /hello-world.php
      /inline-editing.php
      
index.php
elementor-floating-menu.php
plugin.php
```


* `assets` directory - holds plugin JavaScript and CSS assets
  * `/js` directory - Holds plugin Javascript Files
  * `/css` directory - Holds plugin CSS Files
* `widgets` directory - Holds Plugin widgets
  * `/floating-menu.php` - Hello World demo Widget class
* `index.php`	- Prevent direct access to directories
* `elementor-floating-menu.php`	- Main plugin file, used as a loader if plugin minimum requirements are met.
* `plugin.php` - The actual Plugin file/Class.

For more documentation please see [Elementor Developers Resource](https://developers.elementor.com/creating-an-extension-for-elementor/).

Plugins achievements
```
- The Floating Menu widget will test if it can be installed on the current version of WordPress.
- Checking if Elementor is installed
- Check if the php version is sufficient> = 7.0 (7.4.10 prod)
- Checking if the version of Elementor is sufficient> = 3.0.0

Back-office :
- Ability to upload and update SVG icons
- Possibility to add an href link to the icon, precision of the target (_blank ...,) and nofollow
- Possibility to add the name of the icon when hovering over an icon in tooltip
- Possibility to define the main icon representing the menu
- Possibility to integrate this menu on all pages or exclude some
- Possibility to modify the background color of each icon and the color of the SVG

Front-office
- Display open on desktop, display close under mobile and tablet when the page is loaded
- Warning: The menu must not appear in the header and footer.
- The design is made up of an icon embedded in a circle.

Example :
- The menu at the bottom left to contact the people on the site.
- https://premio.io/downloads/mystickyelements/#
```