<?php

/**
 * The public-facing functionality of the plugin.
 *
 * @link       https://www.digitalseeder.com
 * @since      1.0.0
 *
 * @package    Avadadisplay
 * @subpackage Avadadisplay/public
 */

/**
 * The public-facing functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the public-facing stylesheet and JavaScript.
 *
 * @package    Avadadisplay
 * @subpackage Avadadisplay/public
 * @author     Digital Seeder <webmaster@digitalseeder>
 */
class Avadadisplay_Public {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string $plugin_name The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string $version The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @param   string  $plugin_name  The name of the plugin.
	 * @param   string  $version      The version of this plugin.
	 *
	 * @since    1.0.0
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version     = $version;

	}

	/**
	 * Register the stylesheets for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Avadadisplay_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Avadadisplay_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/avadadisplay-public.css', array(), $this->version, 'all' );

	}

	/**
	 * Register the JavaScript for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Avadadisplay_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Avadadisplay_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/avadadisplay-public.js', array( 'jquery' ), $this->version, false );

	}

	public function avada_filter_container_parameters( $out, $tag, $atts ) {

		$china_urls = array(
			'www.artefactchina.com',
			'staging.artefactchina.com',
			'test.artefactchina.com',
		);

		if ( substr( $tag, 0, 6 ) == 'fusion' ) {
			if ( isset( $atts['artefact_hide'] ) && ! empty( $atts['artefact_hide'] ) ) {
				/**
				 *
				 * [0] => artefact_global
				 * [1] => artefact_china
				 */
				$avada_rules = preg_split( '/,/', $atts['artefact_hide'] );
				
				/**
				 * host of site
				 */
				$host_url = $_SERVER['SERVER_NAME'];

				//Display only on artefact.com
				if ( "www.artefact.com" === $host_url && ! in_array( "artefact_global", $avada_rules ) ) {
					$out = '';
				}
				if ( in_array( $host_url, $china_urls ) && ! in_array( "artefact_china", $avada_rules ) ) {
					$out = '';
				}
			}
		}

		return $out;
	}
}
