<?php

class Avadadisplay_Setting {

	public function avada_setting_page() {
		add_submenu_page( 'options-general.php', 'Avada Display', 'Avada Display', 'manage_options', 'avada_display_options_page', [
			$this,
			'avada_display_options_page'
		] );
	}

	public function avada_register_settings() {

		register_setting( 'avada_display_options_group', 'avada_display_setting' );

		add_settings_section(
			'avada_display_section',
			'',
			'' ,
			$this->plugin_name
		);

		add_settings_field(
			'avada_display_textarea_field_script_header',
			__( 'Tracking Code in header', 'avadadisplay' ),
			[ $this, 'avada_display_textarea_field_script_header_render' ],
			$this->plugin_name,
			'avada_display_section'
		);

		add_settings_field(
			'avada_display_textarea_field_script_footer',
			__( 'Tracking Code in footer', 'avadadisplay' ),
			[ $this, 'avada_display_textarea_field_script_footer_render' ],
			$this->plugin_name,
			'avada_display_section'
		);
	}

    public function avada_display_textarea_field_script_header_render() {
		$setting = get_option( 'avada_display_textarea_field_script_header', '' );
		?>
		<textarea cols='40' rows='5' name='avada_display_textarea_field_script_header'><?php echo esc_attr( $setting ); ?></textarea>
		<?php
	}

	public function avada_display_textarea_field_script_footer_render() {
		$setting = get_option( 'avada_display_textarea_field_script_footer', '' );
		?>
		<textarea cols='40' rows='5' name='avada_display_textarea_field_script_footer'><?php echo esc_attr( $setting ); ?></textarea>
		<?php
	}

	public function avada_display_options_page(  ) {
		?>
		<form action='options-general.php?page=avada_display_options_page' method='post'>
            <h1><?php echo esc_html( get_admin_page_title() ); ?></h1>
			<h2><?php _e('Code Fields (Tracking etc.)', 'avadadisplay'); ?></h2>
			<?php
			settings_fields( 'avada_display_options_group' );
			do_settings_sections( $this->plugin_name );
			submit_button();
			?>
		</form>
		<?php
	}
}