<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * @link       https://www.digitalseeder.com
 * @since      1.0.0
 *
 * @package    Avadadisplay
 * @subpackage Avadadisplay/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Avadadisplay
 * @subpackage Avadadisplay/admin
 * @author     Digital Seeder <webmaster@digitalseeder>
 */
class Avadadisplay_Admin {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string $plugin_name The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string $version The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @param   string  $plugin_name  The name of this plugin.
	 * @param   string  $version      The version of this plugin.
	 *
	 * @since    1.0.0
	 */
	public function __construct( $plugin_name, $version ) {
		$this->plugin_name = $plugin_name;
		$this->version     = $version;
	}

	/**
	 * Register the stylesheets for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Avadadisplay_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Avadadisplay_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */


	}

	/**
	 * Register the JavaScript for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Avadadisplay_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Avadadisplay_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */
	}

	/**
	 * Add option in general Avada Panel
	 *
	 * @param $fusion_builder_elements
	 *
	 * @return array
	 */
	public function avada_filter_available_element( $fusion_builder_elements ) {
		if ( isset( $fusion_builder_elements ) ) {
			foreach ( $fusion_builder_elements as $element => $value ) {

				if ( $element === 'fusion_chart' || $element === 'fusion_pricing_table' ) {
					continue;
				}

				// Add param : param_name "artefact_hide in shortcode
				// Add in General panel
				$fusion_builder_elements[ $element ]['params'][] = array(
					'type'        => 'checkbox_button_set',
					'heading'     => esc_attr__( 'On which site would you like to display this item ?', 'fbshc_show_hide' ),
					'description' => esc_attr__( 'Select site that should be able to see this. Use the logged option to view changes only for you on the front end', 'fbshc_show_hide' ),
					'param_name'  => 'artefact_hide',
					'value'       => [
						"artefact_global"  => esc_attr__( "Artefact Global", 'fbshc_show_hide' ),
						"artefact_china"   => esc_attr__( "Artefact China", 'fbshc_show_hide' ),
					],
					'default'     => 'artefact_global,artefact_china',
					'group'       => __( 'General', 'fbshc_show_hide' ),
				);

			}
		}

		return $fusion_builder_elements;
	}

}
