<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://www.digitalseeder.com/
 * @since             1.0.0
 * @package           Wp_Sticky_Button
 *
 * @wordpress-plugin
 * Plugin Name:       WpStickyButton
 * Plugin URI:        https://www.digitalseeder.com/projets/wp-sticky-button/
 * Description:       Add a sticky button to your front interface.
 * Version:           1.0.0
 * Author:            DigitalSeeder
 * Author URI:        https://www.digitalseeder.com/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       wp-sticky-button
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
if ( ! defined( 'WP_STICKY_BUTTON_VERSION' ) ) {
	define( 'WP_STICKY_BUTTON_VERSION', '1.0.0' );
}
if ( ! defined( 'WP_STICKY_BUTTON_I18N' ) ) {
	define( 'WP_STICKY_BUTTON_I18N', 'wp-sticky-button' );
}

if ( ! defined( 'WP_STICKY_PATH_DIR' ) ) {
	define( 'WP_STICKY_PATH_DIR', WP_PLUGIN_DIR . '/wp-sticky-button/' );
}
if ( ! defined( 'WP_STICKY_PATH_HTTP' ) ) {
	define( 'WP_STICKY_PATH_HTTP', plugin_dir_url( __FILE__ ) );
}
if ( ! defined( 'WP_STICKY_PATH_PLUGING' ) ) {
	define( 'WP_STICKY_PATH_PLUGING', plugin_basename( __FILE__ ) );
}

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-wp-sticky-button-activator.php
 */
function activate_wp_sticky_button() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-wp-sticky-button-activator.php';
	Wp_Sticky_Button_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-wp-sticky-button-deactivator.php
 */
function deactivate_wp_sticky_button() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-wp-sticky-button-deactivator.php';
	Wp_Sticky_Button_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_wp_sticky_button' );
register_deactivation_hook( __FILE__, 'deactivate_wp_sticky_button' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-wp-sticky-button.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_wp_sticky_button() {

	$plugin = new Wp_Sticky_Button();
	$plugin->run();

}

run_wp_sticky_button();
