<?php

/**
 * The public-facing functionality of the plugin.
 *
 * @link       https://www.digitalseeder.com/
 * @since      1.0.0
 *
 * @package    Wp_Sticky_button
 * @subpackage Wp_Sticky_button/public
 */

/**
 * The public-facing functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the public-facing stylesheet and JavaScript.
 *
 * @package    Wp_Sticky_button
 * @subpackage Wp_Sticky_button/public
 * @author     DigitalSeeder <webmaster@digitalseeder.com>
 */
class Wp_Sticky_Button_Public {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string $plugin_name The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string $version The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @param   string  $plugin_name  The name of the plugin.
	 * @param   string  $version      The version of this plugin.
	 *
	 * @since    1.0.0
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version     = $version;

	}

	/**
	 * Register the stylesheets for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/sticky-button-public.css', [], $this->version, 'all' );
	}

	/**
	 * Add sticky button in footer
	 *
	 * @return void
	 */
	public function wp_sticky_button_display_in_footer() {

		$options                                          = array();
		$options['--ds_wp_sticky_background_color']       = get_option( 'ds_wp_sticky_background_color' );
		$options['--ds_wp_sticky_padding_top']            = get_option( 'ds_wp_sticky_padding_top' ) . 'px';
		$options['--ds_wp_sticky_padding_right']          = get_option( 'ds_wp_sticky_padding_right' ) . 'px';
		$options['--ds_wp_sticky_padding_bottom']         = get_option( 'ds_wp_sticky_padding_bottom' ) . 'px';
		$options['--ds_wp_sticky_padding_left']           = get_option( 'ds_wp_sticky_padding_left' ) . 'px';
		$options['--ds_wp_sticky_radius_top']             = get_option( 'ds_wp_sticky_radius_top' ) . 'px';
		$options['--ds_wp_sticky_radius_right']           = get_option( 'ds_wp_sticky_radius_right' ) . 'px';
		$options['--ds_wp_sticky_radius_bottom']          = get_option( 'ds_wp_sticky_radius_bottom' ) . 'px';
		$options['--ds_wp_sticky_radius_left']            = get_option( 'ds_wp_sticky_radius_left' ) . 'px';
		$options['--ds_wp_sticky_text_size']              = get_option( 'ds_wp_sticky_text_size' ) . 'px';
		$options['--ds_wp_sticky_radius']                 = get_option( 'ds_wp_sticky_radius' ) . 'px';
		$options['--ds_wp_sticky_text_color']             = get_option( 'ds_wp_sticky_text_color' );
		$options['--ds_wp_sticky_zindex']                 = get_option( 'ds_wp_sticky_zindex' );
		$options['--ds_wp_sticky_underline']              = get_option( 'ds_wp_sticky_underline' );
		$options['--ds_wp_sticky_background_hover_color'] = get_option( 'ds_wp_sticky_background_hover_color' );
		$options['--ds_wp_sticky_text_hover_color']       = get_option( 'ds_wp_sticky_text_hover_color' );

		$style_css = '';
		foreach ( $options as $key => $val ) {
			$style_css .= $key . ':' . esc_attr( $val ) . ';';
		}

		$template_html = '';
		require WP_STICKY_PATH_DIR . 'public/partials/class-sticky-button-display.php';

		$html = str_replace( array(
			'#STYLES#',
			'#TARGET#',
			'#HREF#',
			'#TEXT#'
		), array(
			$style_css,
			get_option( 'ds_wp_sticky_target' ),
			esc_url_raw( get_option( 'ds_wp_sticky_href' ) ),
			esc_attr( get_option( 'ds_wp_sticky_link' ) )
		), $template_html );

		echo $html;

	}
}