<?php

class Wp_Sticky_Button_Settings {

	public function update() {

		if ( ! current_user_can( 'manage_options' ) ) {
			return;
		}

		if ( isset( $_POST['action'] ) && 'ds_wp_sticky' === $_POST['action'] &&
		     wp_verify_nonce( $_POST['_wpnonce'], 'ds_sticky_upgrade' ) ) {

			update_option( 'ds_wp_sticky_position', esc_attr( $_POST['ds_wp_sticky_position'] ) );
			update_option( 'ds_wp_sticky_background_color', esc_attr( $_POST['ds_wp_sticky_background_color'] ) );
			update_option( 'ds_wp_sticky_background_hover_color', esc_attr( $_POST['ds_wp_sticky_background_hover_color'] ) );
			update_option( 'ds_wp_sticky_border_color', esc_attr( $_POST['ds_wp_sticky_border_color'] ) );
			update_option( 'ds_wp_sticky_text_color', esc_attr( $_POST['ds_wp_sticky_text_color'] ) );
			update_option( 'ds_wp_sticky_text_hover_color', esc_attr( $_POST['ds_wp_sticky_text_hover_color'] ) );
			update_option( 'ds_wp_sticky_text_size', esc_attr( $_POST['ds_wp_sticky_text_size'] ) );
			update_option( 'ds_wp_sticky_radius_left', esc_attr( $_POST['ds_wp_sticky_radius_left'] ) );
			update_option( 'ds_wp_sticky_radius_top', esc_attr( $_POST['ds_wp_sticky_radius_top'] ) );
			update_option( 'ds_wp_sticky_radius_right', esc_attr( $_POST['ds_wp_sticky_radius_right'] ) );
			update_option( 'ds_wp_sticky_radius_bottom', esc_attr( $_POST['ds_wp_sticky_radius_bottom'] ) );
			update_option( 'ds_wp_sticky_link', esc_attr( $_POST['ds_wp_sticky_link'] ) );
			update_option( 'ds_wp_sticky_href', esc_attr( $_POST['ds_wp_sticky_href'] ) );
			update_option( 'ds_wp_sticky_mobile', esc_attr( $_POST['ds_wp_sticky_mobile'] ) );
			update_option( 'ds_wp_sticky_padding_left', esc_attr( $_POST['ds_wp_sticky_padding_left'] ) );
			update_option( 'ds_wp_sticky_padding_top', esc_attr( $_POST['ds_wp_sticky_padding_top'] ) );
			update_option( 'ds_wp_sticky_padding_right', esc_attr( $_POST['ds_wp_sticky_padding_right'] ) );
			update_option( 'ds_wp_sticky_padding_bottom', esc_attr( $_POST['ds_wp_sticky_padding_bottom'] ) );
			update_option( 'ds_wp_sticky_zindex', esc_attr( $_POST['ds_wp_sticky_zindex'] ) );
			update_option( 'ds_wp_sticky_underline', esc_attr( $_POST['ds_wp_sticky_underline'] ) );
			update_option( 'ds_wp_sticky_target', esc_attr( $_POST['ds_wp_sticky_target'] ) );
			update_option( 'ds_wp_sticky_border_size', esc_attr( $_POST['ds_wp_sticky_border_size'] ) );
		}

		require WP_STICKY_PATH_DIR . 'admin/partials/wp-sticky-button-admin-display.php';
	}
}
