<?php

/**
 * Fired during plugin deactivation
 *
 * @link       https://www.digitalseeder.com/
 * @since      1.0.0
 *
 * @package    Wp_Sticky_button
 * @subpackage Wp_Sticky_button/includes
 */

/**
 * Fired during plugin deactivation.
 *
 * This class defines all code necessary to run during the plugin's deactivation.
 *
 * @since      1.0.0
 * @package    Wp_Sticky_button
 * @subpackage Wp_Sticky_button/includes
 * @author     DigitalSeeder <webmaster@digitalseeder.com>
 */
class Wp_Sticky_Button_Deactivator {

	/**
	 * Short Description. (use period)
	 *
	 * Long Description.
	 *
	 * @since    1.0.0
	 */
	public static function deactivate() {
		delete_option( 'ds_wp_sticky_position' );
		delete_option( 'ds_wp_sticky_background_color' );
		delete_option( 'ds_wp_sticky_background_hover_color' );
		delete_option( 'ds_wp_sticky_border_color' );
		delete_option( 'ds_wp_sticky_text_color' );
		delete_option( 'ds_wp_sticky_text_hover_color' );
		delete_option( 'ds_wp_sticky_text_size' );
		delete_option( 'ds_wp_sticky_radius_left' );
		delete_option( 'ds_wp_sticky_radius_top' );
		delete_option( 'ds_wp_sticky_radius_right' );
		delete_option( 'ds_wp_sticky_radius_bottom' );
		delete_option( 'ds_wp_sticky_link' );
		delete_option( 'ds_wp_sticky_href' );
		delete_option( 'ds_wp_sticky_mobile' );
		delete_option( 'ds_wp_sticky_padding_left' );
		delete_option( 'ds_wp_sticky_padding_top' );
		delete_option( 'ds_wp_sticky_padding_right' );
		delete_option( 'ds_wp_sticky_padding_bottom' );
		delete_option( 'ds_wp_sticky_zindex' );
		delete_option( 'ds_wp_sticky_underline' );
		delete_option( 'ds_wp_sticky_target' );
		delete_option( 'ds_wp_sticky_border_size' );
	}
}
