<div id="ds_wp_sticky" class="wrap ds_container">
    <div id="ds_grid">
        <aside class="ds_aside">
            <img src="<?php echo WP_STICKY_PATH_HTTP ?>assets/sticky-button.webp" alt="Sitcky Button"/>
            <h1 class="ds_title"><?php _e( 'Sticky Button', WP_STICKY_BUTTON_I18N ); ?></h1>
        </aside>

        <!-- content -->
        <form action="admin.php?page=ds_wp_sticky" method="POST">
			<?php wp_nonce_field( 'ds_sticky_upgrade' ); ?>
            <input type="hidden"
                   name="action"
                   value="ds_wp_sticky"/>

            <div class="ds_body">
                <div class="ds_block">
                    <h2 class="ds_title"><?php _e( 'Settings', WP_STICKY_BUTTON_I18N ); ?></h2>
					<?php echo $admin_notice; ?>
                </div>

                <div class="ds_block">
                    <h2 class="ds_title"><?php _e( 'Position setting', WP_STICKY_BUTTON_I18N ); ?></h2>
                    <table class="form-table ds_table">
                        <tr>
                            <th scope="row">
                                <label for="ds_wp_sticky_position"><?php
									_e( 'Button position:', WP_STICKY_BUTTON_I18N ); ?>
                                </label>
                            </th>
                            <td>
                                <select name="ds_wp_sticky_position" class="ds_input">
									<?php $current = get_option( 'ds_wp_sticky_position', 'left' ); ?>
                                    <option value="left" <?php selected( 'left', esc_attr( $current ) ); ?>><?php _e( 'Left', WP_STICKY_BUTTON_I18N ); ?></option>
                                    <option value="right" <?php selected( 'right', esc_attr( $current ) ); ?>><?php _e( 'Right', WP_STICKY_BUTTON_I18N ); ?></option>
                                </select>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">
                                <label for="ds_wp_sticky_mobile"><?php _e( "Show on mobile ?", WP_STICKY_BUTTON_I18N ); ?></label>
                            </th>
                            <td><select name="ds_wp_sticky_mobile" class="ds_input">
									<?php $current = get_option( 'ds_wp_sticky_mobile', 'yes' ); ?>
                                    <option value="no" <?php selected( 'no', esc_attr( $current ) ); ?>><?php _e( 'No', WP_STICKY_BUTTON_I18N ); ?></option>
                                    <option value="yes" <?php selected( 'yes', esc_attr( $current ) ); ?>><?php _e( 'Yes', WP_STICKY_BUTTON_I18N ); ?></option>
                                </select>
                            </td>
                        </tr>

                        <tr>
                            <th scope="row">
                                <label for="ds_wp_sticky_zindex"><?php _e( "Z-index", WP_STICKY_BUTTON_I18N ); ?></label>
                            </th>
                            <td><input type="text" class="ds_input" name="ds_wp_sticky_zindex"
                                       value="<?php echo esc_attr( get_option( 'ds_wp_sticky_zindex', '9999' ) ); ?>"/>
                            </td>
                        </tr>
                    </table>
                </div>

                <div class="ds_block">
                    <h2 class="ds_title"><?php _e( 'Background setting', WP_STICKY_BUTTON_I18N ); ?></h2>
                    <table class="form-table ds_table">
                        <tr>
                            <th scope="row">
                                <label for="ds_wp_sticky_background_color"><?php
									_e( 'Background color:', WP_STICKY_BUTTON_I18N ); ?>
                                </label>
                            </th>
                            <td>
                                <input type="text" name="ds_wp_sticky_background_color" class="ds_input color-field"
                                       value="<?php echo esc_attr( get_option( 'ds_wp_sticky_background_color', '#FFF' ) ); ?>"/>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">
                                <label for="ds_wp_sticky_background_hover_color"><?php
									_e( 'Background hover color:', WP_STICKY_BUTTON_I18N ); ?>
                                </label>
                            </th>
                            <td>
                                <input type="text" name="ds_wp_sticky_background_hover_color"
                                       class="ds_input color-field"
                                       value="<?php echo esc_attr( get_option( 'ds_wp_sticky_background_hover_color', '#FFF' ) ); ?>"/>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">
                                <label for="ds_wp_sticky_padding_top"><?php _e( "Padding (px)", WP_STICKY_BUTTON_I18N ); ?></label>
                            </th>
                            <td><?php _e( 'Top', WP_STICKY_BUTTON_I18N ); ?>
                                <input type="text" class="ds_input"
                                       style="width:75px;margin-right:15px;"
                                       name="ds_wp_sticky_padding_top"
                                       value="<?php echo esc_attr( get_option( 'ds_wp_sticky_padding_top', '15' ) ); ?>"/>
								<?php _e( 'Right', WP_STICKY_BUTTON_I18N ); ?>
                                <input type="text" class="ds_input" style="margin-right:15px;width:75px"
                                       name="ds_wp_sticky_padding_right"
                                       value="<?php echo esc_attr( get_option( 'ds_wp_sticky_padding_right', '10' ) ); ?>"/>
								<?php _e( 'Bottom', WP_STICKY_BUTTON_I18N ); ?>
                                <input type="text" class="ds_input" style="margin-right:15px;width:75px"
                                       name="ds_wp_sticky_padding_bottom"
                                       value="<?php echo esc_attr( get_option( 'ds_wp_sticky_padding_bottom', '15' ) ); ?>"/>
								<?php _e( 'Left', WP_STICKY_BUTTON_I18N ); ?>
                                <input type="text" class="ds_input" style="margin-right:15px;width:75px"
                                       name="ds_wp_sticky_padding_left"
                                       value="<?php echo esc_attr( get_option( 'ds_wp_sticky_padding_left', '10' ) ); ?>"/>
                            </td>
                        </tr>

                        <tr>
                            <th scope="row">
                                <label for="ds_wp_sticky_border_size"><?php _e( "Border size (px)", WP_STICKY_BUTTON_I18N ); ?></label>
                            </th>
                            <td><input type="text" class="ds_input" name="ds_wp_sticky_border_size"
                                       value="<?php echo esc_attr( get_option( 'ds_wp_sticky_border_size', '0' ) ); ?>"/>
                            </td>
                        </tr>

                        <tr>
                            <th scope="row">
                                <label for="ds_wp_sticky_radius_top"><?php _e( "Border radius size (px)", WP_STICKY_BUTTON_I18N ); ?></label>
                            </th>
                            <td><?php _e( 'Top-left', WP_STICKY_BUTTON_I18N ); ?>
                                <input type="text" class="ds_input"
                                       style="width:45px;margin-right:10px;"
                                       name="ds_wp_sticky_radius_top"
                                       value="<?php echo esc_attr( get_option( 'ds_wp_sticky_radius_top', '10' ) ); ?>"/>
								<?php _e( 'Top-right', WP_STICKY_BUTTON_I18N ); ?>
                                <input type="text" class="ds_input" style="margin-right:10px;width:45px"
                                       name="ds_wp_sticky_radius_right"
                                       value="<?php echo esc_attr( get_option( 'ds_wp_sticky_radius_right', '10' ) ); ?>"/>
								<?php _e( 'Bottom-right', WP_STICKY_BUTTON_I18N ); ?>
                                <input type="text" class="ds_input" style="margin-right:10px;width:45px"
                                       name="ds_wp_sticky_radius_bottom"
                                       value="<?php echo esc_attr( get_option( 'ds_wp_sticky_radius_bottom', '10' ) ); ?>"/>
								<?php _e( 'Bottom-left', WP_STICKY_BUTTON_I18N ); ?>
                                <input type="text" class="ds_input" style="margin-right:15px;width:45px"
                                       name="ds_wp_sticky_radius_left"
                                       value="<?php echo esc_attr( get_option( 'ds_wp_sticky_radius_left', '10' ) ); ?>"/>
                            </td>
                        </tr>

                        <tr>
                            <th scope="row">
                                <label for="ds_wp_sticky_border_color"><?php
									_e( 'Border color:', WP_STICKY_BUTTON_I18N ); ?>
                                </label>
                            </th>
                            <td>
                                <input type="text" name="ds_wp_sticky_border_color" class="ds_input color-field"
                                       value="<?php echo esc_attr( get_option( 'ds_wp_sticky_border_color', '#FFF' ) ); ?>"/>
                            </td>
                        </tr>
                    </table>
                </div>

                <div class="ds_block">
                    <h2 class="ds_title"><?php _e( 'Text link setting', WP_STICKY_BUTTON_I18N ); ?></h2>
                    <table class="form-table ds_table">
                        <tr>
                            <th scope="row">
                                <label for="ds_wp_sticky_text_color">
									<?php _e( "Text color", WP_STICKY_BUTTON_I18N ); ?>
                                </label>
                            </th>
                            <td><input type="text" name="ds_wp_sticky_text_color" class="ds_input color-field"
                                       value="<?php echo esc_attr( get_option( 'ds_wp_sticky_text_color', '#333333' ) ); ?>"/>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">
                                <label for="ds_wp_sticky_text_hover_color">
									<?php _e( "Text color hover", WP_STICKY_BUTTON_I18N ); ?>
                                </label>
                            </th>
                            <td><input type="text" name="ds_wp_sticky_text_hover_color" class="ds_input color-field"
                                       value="<?php echo esc_attr( get_option( 'ds_wp_sticky_text_hover_color', '#333333' ) ); ?>"/>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">
                                <label for="ds_wp_sticky_underline"><?php _e( "Text decoration", WP_STICKY_BUTTON_I18N ); ?></label>
                            </th>
                            <td><select name="ds_wp_sticky_underline" class="ds_input">
									<?php $current = get_option( 'ds_wp_sticky_underline', 'none' ); ?>
                                    <option value="none" <?php selected( 'none', esc_attr( $current ) ); ?>><?php _e( 'None', WP_STICKY_BUTTON_I18N ); ?></option>
                                    <option value="underline" <?php selected( 'underline', esc_attr( $current ) ); ?>><?php _e( 'Underline', WP_STICKY_BUTTON_I18N ); ?></option>
                                </select>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">
                                <label for="ds_wp_sticky_text_size"><?php _e( "Font size (px)", WP_STICKY_BUTTON_I18N ); ?></label>
                            </th>
                            <td><input type="text" class="ds_input" name="ds_wp_sticky_text_size"
                                       value="<?php echo esc_attr( get_option( 'ds_wp_sticky_text_size', '14' ) ); ?>"/>
                            </td>
                        </tr>
                    </table>
                </div>

                <div class="ds_block">
                    <h2 class="ds_title"><?php _e( 'Link setting', WP_STICKY_BUTTON_I18N ); ?></h2>
                    <table class="form-table ds_table">
                        <tr>
                            <th scope="row">
                                <label for="ds_wp_sticky_link"><?php _e( "Link text", WP_STICKY_BUTTON_I18N ); ?></label>
                            </th>
                            <td><input type="text" class="ds_input" name="ds_wp_sticky_link"
                                       value="<?php echo esc_attr( get_option( 'ds_wp_sticky_link', '' ) ); ?>"/>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">
                                <label for="ds_wp_sticky_target"><?php _e( "Target", WP_STICKY_BUTTON_I18N ); ?></label>
                            </th>
                            <td><select name="ds_wp_sticky_target" class="ds_input">
									<?php $current = get_option( 'ds_wp_sticky_target', '_blank' ); ?>
                                    <option value="_blank" <?php selected( '_blank', esc_attr( $current ) ); ?>><?php _e( 'Blank', WP_STICKY_BUTTON_I18N ); ?></option>
                                    <option value="_self" <?php selected( '_self', esc_attr( $current ) ); ?>><?php _e( 'Self', WP_STICKY_BUTTON_I18N ); ?></option>
                                    <option value="_parent" <?php selected( '_parent', esc_attr( $current ) ); ?>><?php _e( 'Parent', WP_STICKY_BUTTON_I18N ); ?></option>
                                    <option value="_top" <?php selected( '_top', esc_attr( $current ) ); ?>><?php _e( 'Top', WP_STICKY_BUTTON_I18N ); ?></option>
                                </select>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">
                                <label for="ds_wp_sticky_href"><?php _e( "Link to", WP_STICKY_BUTTON_I18N ); ?></label>
                            </th>
                            <td><input type="text" placeholder="https://www.your-site.com/"
                                       class="ds_input"
                                       name="ds_wp_sticky_href"
                                       value="<?php echo esc_attr( get_option( 'ds_wp_sticky_href', '' ) ); ?>"/>
                            </td>
                        </tr>
                    </table>
                </div>

                <div class="ds_block">
					<?php submit_button( __( 'SAVE YOUR SETTINGS', WP_STICKY_BUTTON_I18N ), 'primary', 'submit', false, [ 'data-style' => 'ds_submit' ] ); ?>
                </div>
        </form>
    </div>

    <!-- aside help -->
    <div>
        <div class="ds_sticky">
            <div class="ds_help">
                <img class="ds_logo"
                     src="<?php echo WP_STICKY_PATH_HTTP ?>assets/digital-seeder.webp"
                     alt="Digital Seeder: Digital Solutions"/>
                <div class="ds_justify">
                    <p>
                        <b><?php _e( 'Sticky Button plugin is a WordPress plugin allowing you to display on all pages of your website, a button with a link that will always remain visible on the screen.', WP_STICKY_BUTTON_I18N ); ?></b><br/>
                    </p>
                </div>
            </div>
            <div class="ds_help">
                <p>
                    <b><a href="https://www.digitalseeder.com"
                          target="_blank"><?php _e( 'Website :', WP_STICKY_BUTTON_I18N ); ?> Digital
                            Seeder</a></b>
                </p>
                <p>
                    <b><a href="mailto:support@digitalseeder.com"><?php _e( 'Support', WP_STICKY_BUTTON_I18N ); ?></a></b>
                </p>
            </div>
        </div>
    </div>
</div>


