<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * @link       https://www.digitalseeder.com/
 * @since      1.0.0
 *
 * @package    Wp_Sticky_button
 * @subpackage Wp_Sticky_button/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Wp_Sticky_button
 * @subpackage Wp_Sticky_button/admin
 * @author     DigitalSeeder <webmaster@digitalseeder.com>
 */
class Wp_Sticky_Button_Admin {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string $plugin_name The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string $version The current version of this plugin.
	 */
	private $version;

	private $class_settings = null;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @param   string  $plugin_name  The name of this plugin.
	 * @param   string  $version      The version of this plugin.
	 *
	 * @since    1.0.0
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name    = $plugin_name;
		$this->version        = $version;
		$this->class_settings = new Wp_Sticky_Button_Settings();

	}

	/**
	 * Register the stylesheets for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/sticky-button-admin.css', array( 'wp-color-picker' ), $this->version, 'all' );
	}

	/**
	 * Register the JavaScript for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/wp-sticky-button-admin.js', array(
			'jquery',
			'wp-color-picker'
		), false, true );
	}

	/**
	 * Add item Wp Sticky in Menu
	 *
	 * @return void
	 */
	public function add_menu_page() {
		add_menu_page(
			'WP Sticky',
			__( 'WP Sticky', WP_STICKY_BUTTON_I18N ),
			'administrator',
			'ds_wp_sticky',
			array( $this->class_settings, 'update' ),
			'dashicons-sticky',
			90
		);

	}

	/**
	 * Add links to settings page
	 *
	 * @param $actions
	 *
	 * @return array
	 */
	public function add_setting_links( $actions ) {
		$mylinks = array(
			'<a href="' . admin_url( 'admin.php?page=ds_wp_sticky' ) . '">' . __( 'Paramètres', WP_STICKY_BUTTON_I18N ) . '</a>',
		);
		$actions = array_merge( $actions, $mylinks );

		return $actions;
	}

}
